/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service.managedsystem.fru;

import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.service.config.ClassUtils;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElementFilter;
import com.ibm.hwmca.fw.service.managedsystem.fru.Fru;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.EnclosureConfigEntry;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.FruConfig;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.FruTableEntry;
import com.ibm.hwmca.fw.service.managedsystem.fru.persist.FruPersistence;
import com.ibm.hwmca.fw.service.managedsystem.persist.ServiceableElementPersistenceException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.service.managedsystem.fru.DefaultFruFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultFruPersistence
extends FruPersistence {
    private static final String TRACE_MASKT = "XRVDFPST";
    private static final String TRACE_MASKF = "XRVDFPSF";
    private static final String TRACE_MASKD = "XRVDFPSD";
    protected Map fruTableMap = null;
    protected String machineType;
    protected String machineModel;
    protected boolean initDone = false;

    public void init(Map initData) throws ServiceableElementPersistenceException {
        this.machineType = (String)initData.get("TYPE");
        this.machineModel = (String)initData.get("MODEL");
        if (this.machineType == null) {
            throw new ServiceableElementPersistenceException("required key[TYPE] not specified");
        }
        if (this.machineModel == null) {
            throw new ServiceableElementPersistenceException("required key[MODEL] not specified");
        }
        try {
            this.fruTableMap = FruConfig.getFruMap(this.machineType, this.machineModel);
            Trace.trace(TRACE_MASKD, "DefaultFruPersistence.init, parsedFruTable:" + this.fruTableMap);
        }
        catch (Exception thrown) {
            if (thrown instanceof ServiceableElementPersistenceException) {
                throw (ServiceableElementPersistenceException)thrown;
            }
            throw new ServiceableElementPersistenceException(thrown);
        }
        this.initDone = true;
    }

    public void store(ServiceableElement element) throws ServiceableElementPersistenceException {
        throw new ServiceableElementPersistenceException("operation not supported by this impl");
    }

    public void store(List list) throws ServiceableElementPersistenceException {
        throw new ServiceableElementPersistenceException("operation not supported by this impl");
    }

    public List load(ServiceableElementFilter filter) throws ServiceableElementPersistenceException {
        Trace.trace(TRACE_MASKT, "-> DefaultFruPersistence load for filter[" + filter + "]");
        if (!this.initDone) {
            throw new ServiceableElementPersistenceException("DefaultFruPersistence.init method not called, or failed");
        }
        ArrayList<Fru> returnList = null;
        if (filter instanceof DefaultFruFilter) {
            List passedFrus = ((DefaultFruFilter)filter).getFruList();
            if (passedFrus != null) {
                returnList = new ArrayList<Fru>();
                Iterator it = passedFrus.iterator();
                while (it.hasNext()) {
                    CommonPaFru pafru = (CommonPaFru)it.next();
                    PASystem pas = pafru.getEnclosureSystem();
                    String fruid = pafru.getId();
                    if (fruid == null) {
                        Trace.trace(TRACE_MASKF, "DefaultFruPersistence.load Fru ID not set in CommonPaFru[" + pafru + "]");
                    } else {
                        Trace.trace(TRACE_MASKF, "DefaultFruPersistence.load looking for a specific FRU id[" + fruid + "]");
                    }
                    String enclosureType = pas.getMachineType();
                    if (enclosureType == null) {
                        Trace.trace(TRACE_MASKF, "<-! DefaultFruPersistence.load enclosureType not set in CommonPaFru[" + pafru + "]");
                        throw new ServiceableElementPersistenceException("enclosureType not set in CommonPaFru[" + pafru + "]");
                    }
                    Trace.trace(TRACE_MASKF, "DefaultFruPersistence.load looking for enclosure type[" + enclosureType + "]");
                    String enclosureModel = pas.getMachineModel();
                    if (enclosureModel == null) {
                        Trace.trace(TRACE_MASKF, "<-! DefaultFruPersistence.load enclosureModel not set in CommonPaFru[" + pafru + "]");
                        throw new ServiceableElementPersistenceException("enclosureModel not set in CommonPaFru[" + pafru + "]");
                    }
                    Trace.trace(TRACE_MASKF, "DefaultFruPersistence.load looking for enclosure model[" + enclosureModel + "]");
                    String enclosureSerial = pas.getMachineSerial();
                    if (enclosureSerial == null) {
                        Trace.trace(TRACE_MASKF, "<-! DefaultFruPersistence.load enclosureSerial not set in CommonPaFru[" + pafru + "]");
                        throw new ServiceableElementPersistenceException("enclosureSerial not set in CommonPaFru[" + pafru + "]");
                    }
                    Trace.trace(TRACE_MASKF, "DefaultFruPersistence.load looking for enclosure serial[" + enclosureSerial + "]");
                    ArrayList locationCodes = pafru.getLocationList();
                    String locationCode = (String)locationCodes.get(0);
                    if (locationCode.indexOf(45) == -1) continue;
                    if (locationCode == null) {
                        Trace.trace(TRACE_MASKF, "<-! DefaultFruPersistence.load no location code for CommonPaFru[" + pafru + "]");
                        throw new ServiceableElementPersistenceException("no location code for CommonPaFru[" + pafru + "]");
                    }
                    Trace.trace(TRACE_MASKF, "DefaultFruPersistence.load looking for FRU location code[" + locationCode + "]");
                    String enclosureKey = enclosureType.toUpperCase() + "|" + enclosureModel.toUpperCase();
                    if (!this.fruTableMap.containsKey(enclosureKey) && !this.fruTableMap.containsKey(enclosureKey = enclosureType.toUpperCase() + "|" + "FEATURE_CODE")) {
                        Trace.trace(TRACE_MASKF, "<-! DefaultFruPersistence.load the Fru table for machine type[" + this.machineType + "],model[" + this.machineModel + "] doesn't define the enclosure type[" + enclosureType + "],model[" + enclosureModel + "]");
                        throw new ServiceableElementPersistenceException("the Fru table for machine type[" + this.machineType + "],model[" + this.machineModel + "] doesn't define the enclosure type[" + enclosureType + "],model[" + enclosureModel + "]");
                    }
                    EnclosureConfigEntry ece = (EnclosureConfigEntry)this.fruTableMap.get(enclosureKey);
                    Map locationCodeMap = ece.getLocations();
                    Object[] possibleFrusAtLocationArray = (Object[])locationCodeMap.get(DefaultFruPersistence.getLocationCodeSuffix(locationCode));
                    if (possibleFrusAtLocationArray == null) {
                        Trace.trace(TRACE_MASKF, "DefaultFruPersistence.load the at location[" + locationCode + "] is not defined for the enclosure type[" + enclosureType + "],model[" + enclosureModel + "]");
                        continue;
                    }
                    FruTableEntry fte = null;
                    FruTableEntry defaultEntry = null;
                    int aii = 0;
                    while (aii < possibleFrusAtLocationArray.length) {
                        if (possibleFrusAtLocationArray[aii] instanceof FruTableEntry) {
                            fte = (FruTableEntry)possibleFrusAtLocationArray[aii];
                            if (defaultEntry == null && fte.getId() == null) {
                                defaultEntry = fte;
                                Trace.trace(TRACE_MASKF, "DefaultFruPersistence.load located default FRU table definition");
                            }
                            if (fruid == fte.getId()) {
                                Trace.trace(TRACE_MASKF, "DefaultFruPersistence.load located FRU table entry with matching id");
                                break;
                            }
                            Trace.trace(TRACE_MASKF, "DefaultFruPersistence.load id mismatch - using default FRU table entry for location");
                            fte = defaultEntry;
                        }
                        ++aii;
                    }
                    if (fte == null) {
                        Trace.trace(TRACE_MASKF, "<-! DefaultFruPersistence.load FRU resolution error: location[" + locationCode + "],fruid[" + fruid + "],enclosureType[" + enclosureType + "],enclosureModel[" + enclosureModel + "]");
                        throw new ServiceableElementPersistenceException("FRU resolution error: location[" + locationCode + "],fruid[" + fruid + "],enclosureType[" + enclosureType + "],enclosureModel[" + enclosureModel + "]");
                    }
                    try {
                        HashMap<String, String> fruProps;
                        Fru fru = (Fru)ClassUtils.instantiate(fte.getClassData());
                        Map fteProps = fte.getProperties();
                        if (fteProps != null) {
                            fruProps = fru.getProperties();
                            if (fruProps != null) {
                                fruProps.putAll(fteProps);
                                fru.setProperties(fruProps);
                            } else {
                                fru.setProperties(fteProps);
                            }
                        }
                        if ((fruProps = fru.getProperties()) == null) {
                            fruProps = new HashMap<String, String>();
                        }
                        fruProps.put("LOCATION", locationCode);
                        fruProps.put("ENCLOSURE_TYPE", enclosureType);
                        fruProps.put("ENCLOSURE_MODEL", enclosureModel);
                        fruProps.put("ENCLOSURE_SERIAL", enclosureSerial);
                        fruProps.put("MANAGED_SYSTEM_TYPE", this.machineType);
                        fruProps.put("MANAGED_SYSTEM_MODEL", this.machineModel);
                        fruProps.put("POWER_BOUNDARY_IS_FRU", (String)((Object)(fte.isPowerBoundary() ? Boolean.TRUE : Boolean.FALSE)));
                        fru.setProperties(fruProps);
                        returnList.add(fru);
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "<-! DefaultFruPersistence.load exception caught instantiating class: " + fte.getClassData());
                        Trace.trace(TRACE_MASKF, e);
                        throw new ServiceableElementPersistenceException(e);
                    }
                }
            }
        } else {
            Trace.trace(TRACE_MASKF, "<-! DefaultFruPersistence.load unsupported filter[" + filter + "]");
            throw new ServiceableElementPersistenceException("unsupported filter :" + filter);
        }
        Trace.trace(TRACE_MASKT, "<- DefaultFruPersistence load, number of frus resolved: " + (returnList == null ? "0" : String.valueOf(returnList.size())));
        return returnList;
    }

    public void remove(ServiceableElement element) throws ServiceableElementPersistenceException {
        throw new ServiceableElementPersistenceException("operation not supported by this impl");
    }

    public void remove(List list) throws ServiceableElementPersistenceException {
        throw new ServiceableElementPersistenceException("operation not supported by this impl");
    }

    protected static String getLocationCodeSuffix(String locationCode) throws ServiceableElementPersistenceException {
        int unitDataDelim = locationCode.indexOf(45);
        if (!locationCode.toUpperCase().startsWith("U")) {
            Trace.trace(TRACE_MASKF, "DefaultFruPersistence.getLocationCodeSuffix ??? no unit data in location code: " + locationCode + ", using entire location code as-is");
            return locationCode.toUpperCase();
        }
        return locationCode.substring(unitDataDelim + 1).toUpperCase();
    }
}

